package gov.va.vinci.dart.json;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="DocumentReviewNote", propOrder={
		"id",
		"documentId",
		"created",
		"note",
		"createdBy"
})
public class DocumentReviewNoteView {

	private int id;
	
	@Min(0)
	private int documentId;
	
	@NotNull
	private String created;
	
	@NotNull
	@Size(min=1)
	private String note;
	
	private String createdBy;

	public String getCreated() {
		return created;
	}

	public void setCreated(String created) {
		this.created = created;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}
	
	public int getId() {
		return id;
	}

	public void setId(int Id) {
		this.id = Id;
	}	

	public int getDocumentId() {
		return documentId;
	}

	public void setDocumentId(int documentId) {
		this.documentId = documentId;
	}
	
	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}
	
}
